/*
 * Decompiled with CFR 0.152.
 */
package replicatorg.plugin.toolpath;

import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import replicatorg.app.Base;
import replicatorg.model.Build;
import replicatorg.plugin.toolpath.SkeinStep;
import replicatorg.plugin.toolpath.ToolpathGenerator;

class ProgressDialog
extends JDialog
implements ToolpathGenerator.GeneratorListener {
    Thread parentThread;
    JLabel topLabel;
    JLabel progressLabel;
    JProgressBar subProgressBar;
    JLabel totalProgressLabel;
    JProgressBar totalProgressBar;
    JButton doneButton;
    int layerIndex;
    int layerTotal;
    int currentProcessI = -1;
    SkeinStep[] steps = new SkeinStep[]{new SkeinStep("Carve", 13), new SkeinStep("Inset", 27), new SkeinStep("Fill", 12), new SkeinStep("Raft", 36), new SkeinStep("Clip", 8), new SkeinStep("Comb", 4), new SkeinStep("Oozebane", 5)};
    boolean done = false;
    private static Pattern patOfNum = Pattern.compile(" of ([0-9]+)...");
    private static Pattern patLayerCount = Pattern.compile("([A-Za-z]+) layer count ([0-9]+)");
    private static Pattern patOldLayerTotal = Pattern.compile("total Layer count is[^0-9]([0-9]+)[^0-9]");
    private static Pattern patFillingLayer = Pattern.compile("^Filling layer.*[^0-9]([0-9]+)[^0-9]");
    private static Pattern patOldFillingLayer = Pattern.compile("Filling layer[^0-9]([0-9]+)/([0-9]+)[^0-9]");
    private static Pattern patSliceToGcode = Pattern.compile("Slice to GCode.*layer ([0-9]+)[^0-9]");
    private static Pattern patProcedureTook = Pattern.compile("(.*) procedure took");

    public ProgressDialog(Frame parent, Build build, Thread parentThread) {
        super(parent);
        this.parentThread = parentThread;
        ImageIcon icon = new ImageIcon(Base.getDirectImage("images/slicing-icon.gif", this));
        this.setTitle("Generating toolpath for " + build.getName());
        this.topLabel = new JLabel("Generating toolpath for " + build.getName(), icon, 2);
        icon.setImageObserver(this.topLabel);
        this.progressLabel = new JLabel("Launching plugin...");
        this.subProgressBar = new JProgressBar();
        this.totalProgressLabel = new JLabel("Total progress:");
        this.totalProgressBar = new JProgressBar();
        this.subProgressBar.setValue(0);
        this.subProgressBar.setStringPainted(false);
        this.subProgressBar.setValue(0);
        this.totalProgressBar.setStringPainted(false);
        this.setLayout((LayoutManager)new MigLayout());
        this.add((Component)this.topLabel, "wrap");
        this.add((Component)new JLabel("Generator: Skeinforge"), "wrap");
        this.add((Component)this.progressLabel, "wrap,growx");
        this.add((Component)this.subProgressBar, "wrap,wmin 400px");
        this.add((Component)this.totalProgressLabel, "wrap,growx");
        this.add((Component)this.totalProgressBar, "wrap,wmin 400px");
        this.doneButton = new JButton("Cancel");
        this.doneButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                1 var2_2 = this;
                synchronized (var2_2) {
                    ProgressDialog.this.abortGeneration();
                }
            }
        });
        this.add((Component)this.doneButton, "tag cancel");
        this.setResizable(false);
        this.setModal(false);
        this.doneButton.addKeyListener(new KeyAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    2 var2_2 = this;
                    synchronized (var2_2) {
                        ProgressDialog.this.abortGeneration();
                    }
                }
            }
        });
    }

    public boolean isDone() {
        return this.done;
    }

    @Override
    public void setVisible(boolean b) {
        if (!b) {
            this.parentThread = null;
        }
        super.setVisible(b);
    }

    public void setDone(boolean done) {
        this.done = done;
    }

    private void abortGeneration() {
        Base.logger.severe("Aborted toolpath generation!");
        this.parentThread.interrupt();
    }

    @Override
    public void updateGenerator(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int sub;
                Matcher m;
                String newMessage = message;
                String processName = "";
                boolean logIt = true;
                boolean showProgress = false;
                if (newMessage.startsWith("\u001b")) {
                    newMessage = newMessage.substring(4);
                }
                if ((m = patOfNum.matcher(newMessage)).find()) {
                    logIt = false;
                    ProgressDialog.this.layerTotal = Integer.parseInt(m.group(1));
                }
                if ((m = patLayerCount.matcher(newMessage)).find()) {
                    processName = m.group(1);
                    ProgressDialog.this.layerIndex = Integer.parseInt(m.group(2));
                    logIt = false;
                    if (ProgressDialog.this.layerTotal > 0) {
                        ProgressDialog.this.subProgressBar.setIndeterminate(false);
                        showProgress = true;
                        newMessage = String.valueOf(processName) + " (layer " + ProgressDialog.this.layerIndex + " of " + ProgressDialog.this.layerTotal + ")";
                    } else {
                        newMessage = String.valueOf(processName) + " (layer " + ProgressDialog.this.layerIndex + ")";
                        ProgressDialog.this.subProgressBar.setIndeterminate(true);
                    }
                }
                if ((m = patOldLayerTotal.matcher(newMessage)).find()) {
                    ProgressDialog.this.layerTotal = Integer.parseInt(m.group(1));
                }
                if ((m = patFillingLayer.matcher(newMessage)).find()) {
                    ProgressDialog.this.layerIndex = Integer.parseInt(m.group(1));
                    showProgress = true;
                    logIt = false;
                    sub = (int)(55.0 * (double)ProgressDialog.this.layerIndex / (double)ProgressDialog.this.layerTotal);
                    ProgressDialog.this.totalProgressBar.setValue(10 + sub);
                }
                if ((m = patOldFillingLayer.matcher(newMessage)).find()) {
                    ProgressDialog.this.layerIndex = Integer.parseInt(m.group(1));
                    ProgressDialog.this.layerTotal = Integer.parseInt(m.group(2));
                    showProgress = true;
                    logIt = false;
                    sub = (int)(55.0 * (double)ProgressDialog.this.layerIndex / (double)ProgressDialog.this.layerTotal);
                    ProgressDialog.this.totalProgressBar.setValue(10 + sub);
                }
                if ((m = patSliceToGcode.matcher(newMessage)).find()) {
                    ProgressDialog.this.layerIndex = Integer.parseInt(m.group(1));
                    showProgress = true;
                    logIt = false;
                    sub = (int)(2.0 * (double)ProgressDialog.this.layerIndex / (double)ProgressDialog.this.layerTotal);
                    ProgressDialog.this.totalProgressBar.setValue(2 + sub);
                }
                if (showProgress) {
                    String j = new Integer(ProgressDialog.this.layerTotal).toString();
                    double completion = (double)ProgressDialog.this.layerIndex / (double)ProgressDialog.this.layerTotal;
                    if (ProgressDialog.this.layerIndex > 0 && processName == "") {
                        newMessage = String.valueOf(newMessage) + " (" + j + " layers)";
                    }
                    ProgressDialog.this.subProgressBar.setValue((int)(100.0 * completion));
                }
                if ((m = patProcedureTook.matcher(newMessage)).find()) {
                    int i = 0;
                    while (i < 5) {
                        if (ProgressDialog.this.steps[i].stepName.equals(m.group(1))) {
                            ProgressDialog.this.currentProcessI = i;
                            ProgressDialog.this.subProgressBar.setIndeterminate(true);
                        }
                        ++i;
                    }
                }
                if (ProgressDialog.this.currentProcessI >= 0) {
                    ProgressDialog.this.totalProgressBar.setValue(ProgressDialog.this.steps[ProgressDialog.this.currentProcessI].getStepPercentage(ProgressDialog.this.layerIndex, ProgressDialog.this.layerTotal));
                } else if (ProgressDialog.this.layerTotal > 0) {
                    ProgressDialog.this.subProgressBar.setValue((int)((double)ProgressDialog.this.layerIndex / (double)ProgressDialog.this.layerTotal * 100.0));
                    ProgressDialog.this.subProgressBar.setIndeterminate(false);
                }
                if (logIt) {
                    Base.logger.info(newMessage);
                }
                ProgressDialog.this.progressLabel.setText(newMessage);
            }
        });
    }

    @Override
    public void generationComplete(ToolpathGenerator.GeneratorListener.Completion completion, Object details) {
    }
}

